<?php

namespace App\Http\Controllers;

use App\Models\Car;
use App\Models\User;
use App\Models\Driver;
use App\Repositories\CarRepository;
use Illuminate\Http\Request;
use App\DataTables\CarDateTable;
use App\Http\Requests;
use App\Http\Requests\CreateCartRequest;
use App\Http\Requests\UpdateCartRequest;
use App\Repositories\CartRepository;
use App\Repositories\CustomFieldRepository;
use App\Repositories\ProductRepository;
use App\Repositories\UserRepository;
use App\Repositories\OptionRepository;
use Flash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Prettus\Validator\Exceptions\ValidatorException;

class CarController extends Controller
{
    private $carRepository;
    public function __construct(CarRepository $carRepo){
        $this->carRepository = $carRepo;
    }
    public function index(CarDateTable $carDataTable){
        //dd(Car::all());
        return $carDataTable->render('car.index');
    }
    public function destroy($id){
        $car = $this->carRepository->findWithoutFail($id);
        
        if (empty($car)) {
            Flash::error('Cart not found');
            return redirect(route('car.index'));
        }
        $this->carRepository->delete($id);

        Flash::success(__('lang.deleted_successfully', ['operator' => __('lang.car')]));

        return redirect(url('car'));
    }
    public function show($id){
        $car = $this->carRepository->findWithoutFail($id);
        $user = User::find($car->owner_id);
        $car->name = $user->name;
        $car->img_id = $user->driver->img_url_id;
        $car->img_car_id =  $user->driver->img_url_car;
        if(empty($car)){
            Flash::error('Cart not found');
            return redirect(url('car/'));
        }
        return view('car/show',['car'=>$car]);
    }
    
    public function update(Request $requset,$id){
        $car = $this->carRepository->findWithoutFail($id);
        $car->Type = $requset->type;
        $car->brand = $requset->brand;
        $car->color = $requset->color;
        $car->capacity = $requset->capacity;
        $car->number = $requset->number;
        $car->save();
        if(empty($car)){
            Flash::error('Cart not found');
            return redirect(url('car/'));
        }
        return redirect(url('car/data/'.$id));
    }
}
